import { ActionSet } from '../ActionSet';
import type { AnyAction, MetaAction } from '../types';
import { ClientApplication } from '../../client';
import { Action, Options, RequestOptions } from './types';
/**
 * @internal
 */
export declare type FeaturesAction = MetaAction | AnyAction;
/**
 * A set of Actions for Updating, Requesting Features of AppBridge
 * @public
 */
export declare class Features extends ActionSet {
    constructor(app: ClientApplication, options?: Options);
    /**
     * @public
     */
    dispatch(action: Action.REQUEST, payload: RequestOptions): this;
    /**
     * @internal
     */
    private dispatchFeaturesAction;
}
/**
 * @public
 */
export declare function create(app: ClientApplication, options?: Options): Features;
