import { Group, MetaAction } from '../types';
export declare enum Action {
    REQUEST = "APP::SESSION_TOKEN::REQUEST",
    RESPOND = "APP::SESSION_TOKEN::RESPOND"
}
export interface Payload {
    sessionToken?: string;
    readonly id?: string;
}
export interface ActionBase extends MetaAction {
    readonly group: typeof Group.SessionToken;
}
export interface RequestSessionTokenAction extends ActionBase {
    readonly type: typeof Action.REQUEST;
}
export interface RespondWithSessionTokenAction extends ActionBase {
    readonly type: typeof Action.RESPOND;
}
export interface SessionTokenApi {
    get(): Promise<string>;
}
export declare function request(): RequestSessionTokenAction;
export declare function respond(sessionToken: Payload): RespondWithSessionTokenAction;
