"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NonSnakeCaseGroup = exports.findMatchInEnum = exports.forEachInEnum = exports.getMergedProps = exports.updateActionFromPayload = exports.isValidOptionalString = exports.isValidOptionalNumber = exports.getEventNameSpace = exports.getVersion = exports.actionWrapper = void 0;
var constants_1 = require("./constants");
var merge_1 = __importDefault(require("./merge"));
var types_1 = require("./types");
// eslint-disable-next-line @typescript-eslint/no-var-requires
var packageJson = require('../package.json');
function actionWrapper(action) {
    return __assign(__assign({}, action), { version: getVersion(), clientInterface: {
            name: packageJson.name,
            version: getVersion(),
        } });
}
exports.actionWrapper = actionWrapper;
function getVersion() {
    return packageJson.version;
}
exports.getVersion = getVersion;
/**
 * Returns full event name with prefix, group, subgroups and type formatted with separators
 * @internal
 * */
function getEventNameSpace(group, eventName, component) {
    if (eventName.startsWith("" + constants_1.PREFIX + constants_1.SEPARATOR)) {
        return eventName;
    }
    var eventNameSpace = groupToEventNameSpace(group);
    if (component) {
        var subgroups_1 = component.subgroups, type = component.type;
        if (subgroups_1 && subgroups_1.length > 0) {
            eventNameSpace += eventNameSpace.length > 0 ? constants_1.SEPARATOR : '';
            subgroups_1.forEach(function (subgroup, index) {
                eventNameSpace += "" + subgroup.toUpperCase() + (index < subgroups_1.length - 1 ? constants_1.SEPARATOR : '');
            });
        }
        if (type !== group && type) {
            eventNameSpace += "" + (eventNameSpace.length > 0 ? constants_1.SEPARATOR : '') + type.toUpperCase();
        }
    }
    if (eventNameSpace) {
        eventNameSpace += "" + (eventNameSpace.length > 0 ? constants_1.SEPARATOR : '') + eventName.toUpperCase();
    }
    return "" + constants_1.PREFIX + constants_1.SEPARATOR + eventNameSpace;
}
exports.getEventNameSpace = getEventNameSpace;
function isValidOptionalNumber(value) {
    return value === null || value === undefined || typeof value === 'number';
}
exports.isValidOptionalNumber = isValidOptionalNumber;
function isValidOptionalString(value) {
    return value === null || value === undefined || typeof value === 'string';
}
exports.isValidOptionalString = isValidOptionalString;
function updateActionFromPayload(action, newProps) {
    var id = action.id;
    if (id === newProps.id) {
        // Merge new properties
        Object.assign(action, getMergedProps(action, newProps));
        return true;
    }
    return false;
}
exports.updateActionFromPayload = updateActionFromPayload;
function getMergedProps(props, newProps) {
    var merged = merge_1.default(props, newProps);
    if (!merged) {
        // tslint:disable-next-line:prefer-object-spread
        var cloned = Object.assign(props, newProps);
        return cloned;
    }
    return merged;
}
exports.getMergedProps = getMergedProps;
function forEachInEnum(types, callback) {
    Object.keys(types).forEach(function (key) {
        callback(types[key]);
    });
}
exports.forEachInEnum = forEachInEnum;
function findMatchInEnum(types, lookup) {
    var match = Object.keys(types).find(function (key) {
        return lookup === types[key];
    });
    return match ? types[match] : undefined;
}
exports.findMatchInEnum = findMatchInEnum;
function camelCaseToSnakeCase(value) {
    return value.replace(/([A-Z])/g, function (matcher, _val, index) {
        return "" + (index === 0 ? '' : '_') + matcher[0].toLowerCase();
    });
}
exports.NonSnakeCaseGroup = [
    types_1.Group.AuthCode,
    types_1.Group.Button,
    types_1.Group.ButtonGroup,
    types_1.Group.Cart,
    types_1.Group.Error,
    types_1.Group.Features,
    types_1.Group.Fullscreen,
    types_1.Group.Link,
    types_1.Group.Loading,
    types_1.Group.Menu,
    types_1.Group.Modal,
    types_1.Group.Navigation,
    types_1.Group.Pos,
    types_1.Group.Print,
    types_1.Group.ResourcePicker,
    types_1.Group.Scanner,
    types_1.Group.SessionToken,
    types_1.Group.Share,
    types_1.Group.TitleBar,
    types_1.Group.Toast,
    types_1.Group.unstable_Picker,
];
/**
 * Maps the group name to its event name
 * @internal
 * @remarks - This method is necessary for the new pattern of using snake case
 * which makes it more readable and easier to reconstruct the group from an event name.
 * Example: `ContextualSaveBar` becomes `CONTEXTUAL_SAVE_BAR`
 * */
function groupToEventNameSpace(group) {
    if (exports.NonSnakeCaseGroup.includes(group)) {
        return group.toUpperCase();
    }
    return camelCaseToSnakeCase(group).toUpperCase();
}
