'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
require('./CustomProperties.scss.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const DEFAULT_COLOR_SCHEME = 'light';

/**
 * @deprecated The CustomProperties component will be removed in the next
 * major version. See the Polaris token documentation for replacing
 * colors relying on dark color scheme values.
 *
 * https://polaris.shopify.com/tokens
 */
function CustomProperties(props) {
  const {
    as: Component = 'div',
    children,
    className,
    colorScheme = DEFAULT_COLOR_SCHEME,
    style
  } = props;

  if (process.env.NODE_ENV === 'development') {
    // eslint-disable-next-line no-console
    console.warn('Deprecation: The `CustomProperties` component has been deprecated. See the v10 migration guide for replacing dark color scheme styles. https://github.com/Shopify/polaris/blob/main/documentation/guides/migrating-from-v9-to-v10.md');
  }

  return /*#__PURE__*/React__default["default"].createElement(Component, {
    "p-color-scheme": colorScheme,
    className: className,
    style: {
      color: 'var(--p-text)',
      ...style
    }
  }, children);
}

exports.CustomProperties = CustomProperties;
exports.DEFAULT_COLOR_SCHEME = DEFAULT_COLOR_SCHEME;
