import React, { useRef } from 'react';
import { SortDescendingMajor, SortAscendingMajor } from '@shopify/polaris-icons';
import { classNames, variationName } from '../../../../utilities/css.js';
import { headerCell } from '../../../shared.js';
import styles from '../../DataTable.scss.js';
import { useI18n } from '../../../../utilities/i18n/hooks.js';
import { Tooltip } from '../../../Tooltip/Tooltip.js';
import { Icon } from '../../../Icon/Icon.js';

function Cell({
  content,
  contentType,
  firstColumn,
  truncate,
  header,
  total,
  totalInFooter,
  sorted,
  sortable,
  sortDirection,
  inFixedFirstColumn,
  verticalAlign = 'top',
  defaultSortDirection = 'ascending',
  onSort,
  colSpan,
  setRef = () => {},
  stickyHeadingCell = false,
  stickyCellWidth,
  hovered = false,
  handleFocus = () => {},
  hasFixedFirstColumn = false,
  fixedCellVisible = false,
  firstColumnMinWidth
}) {
  const i18n = useI18n();
  const numeric = contentType === 'numeric';
  const className = classNames(styles.Cell, styles[`Cell-${variationName('verticalAlign', verticalAlign)}`], firstColumn && styles['Cell-firstColumn'], firstColumn && truncate && styles['Cell-truncated'], header && styles['Cell-header'], total && styles['Cell-total'], totalInFooter && styles['Cell-total-footer'], numeric && styles['Cell-numeric'], sortable && styles['Cell-sortable'], sorted && styles['Cell-sorted'], stickyHeadingCell && styles.StickyHeaderCell, hovered && styles['Cell-hovered'], fixedCellVisible && styles.separate, firstColumn && inFixedFirstColumn && stickyHeadingCell && styles.FixedFirstColumn);
  const headerClassName = classNames(header && styles.Heading, header && contentType === 'text' && styles['Heading-left']);
  const iconClassName = classNames(sortable && styles.Icon);
  const direction = sorted && sortDirection ? sortDirection : defaultSortDirection;
  const source = direction === 'descending' ? SortDescendingMajor : SortAscendingMajor;
  const oppositeDirection = sortDirection === 'ascending' ? 'descending' : 'ascending';
  const sortAccessibilityLabel = i18n.translate('Polaris.DataTable.sortAccessibilityLabel', {
    direction: sorted ? oppositeDirection : direction
  });
  const iconMarkup = /*#__PURE__*/React.createElement("span", {
    className: iconClassName
  }, /*#__PURE__*/React.createElement(Icon, {
    source: source,
    accessibilityLabel: sortAccessibilityLabel
  }));
  const focusable = !(stickyHeadingCell && hasFixedFirstColumn && firstColumn && !inFixedFirstColumn);
  const sortableHeadingContent = /*#__PURE__*/React.createElement("button", {
    className: headerClassName,
    onClick: onSort,
    onFocus: handleFocus,
    tabIndex: focusable ? 0 : -1
  }, iconMarkup, content);
  const columnHeadingContent = sortable ? sortableHeadingContent : content;
  const colSpanProp = colSpan && colSpan > 1 ? {
    colSpan
  } : {};
  const stickyHeading = /*#__PURE__*/React.createElement("th", Object.assign({
    ref: setRef
  }, headerCell.props, colSpanProp, {
    className: className,
    "aria-sort": sortDirection,
    style: firstColumn && firstColumnMinWidth ? {
      minWidth: firstColumnMinWidth
    } : {
      minWidth: stickyCellWidth
    },
    "data-index-table-sticky-heading": true
  }), columnHeadingContent);
  const headingMarkup = header ? /*#__PURE__*/React.createElement("th", Object.assign({}, headerCell.props, colSpanProp, {
    ref: setRef,
    className: className,
    scope: "col",
    "aria-sort": sortDirection,
    style: firstColumn ? {
      minWidth: firstColumnMinWidth
    } : {}
  }), columnHeadingContent) : /*#__PURE__*/React.createElement("th", Object.assign({
    style: {
      minWidth: firstColumnMinWidth
    },
    className: className,
    scope: "row"
  }, colSpanProp, {
    ref: ref => {
      setRef(ref);
    }
  }), /*#__PURE__*/React.createElement(TruncatedText, {
    className: styles.TooltipContent
  }, content));
  const cellMarkup = header || firstColumn ? headingMarkup : /*#__PURE__*/React.createElement("td", Object.assign({
    className: className
  }, colSpanProp), content);
  return stickyHeadingCell ? stickyHeading : cellMarkup;
}

const TruncatedText = ({
  children,
  className = ''
}) => {
  const textRef = useRef(null);
  const {
    current
  } = textRef;
  const text = /*#__PURE__*/React.createElement("span", {
    ref: textRef,
    className: className
  }, children);
  return (current === null || current === void 0 ? void 0 : current.scrollWidth) > (current === null || current === void 0 ? void 0 : current.offsetWidth) ? /*#__PURE__*/React.createElement(Tooltip, {
    content: textRef.current.innerText
  }, text) : text;
};

export { Cell };
