import React from 'react';
import { ColorScheme } from '@shopify/polaris-tokens';
import './CustomProperties.scss';
export declare const DEFAULT_COLOR_SCHEME: ColorScheme;
export interface CustomPropertiesProps {
    /** Determines what color scheme is applied to child content. */
    colorScheme?: ColorScheme;
    /** The content to display. */
    children?: React.ReactNode;
    /** Class name applied to the root element. */
    className?: string;
    /** Inline styles applied to the root element. */
    style?: React.CSSProperties;
    /** Element used for the root node. */
    as?: React.ElementType;
}
/**
 * @deprecated The CustomProperties component will be removed in the next
 * major version. See the Polaris token documentation for replacing
 * colors relying on dark color scheme values.
 *
 * https://polaris.shopify.com/tokens
 */
export declare function CustomProperties(props: CustomPropertiesProps): JSX.Element;
//# sourceMappingURL=CustomProperties.d.ts.map
